function geom = Ibend3D(geomparams)


%% PARAMETERS
%pre-bend straight length L1, post-bend straight length L2, bend radius and
% and angle R_B and theta_B, duct radius R_i
if ~exist('geomparams','var')
    geomparams.Lhat     = 5;
    geomparams.R_i      = 0.9;
    geomparams.Rhat     = 1;
end

R_i         = geomparams.R_i;
Rhat        = geomparams.Rhat;

L1I = 7+Rhat+R_i;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
geom.L      = L1I;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) 0;
geom.qy = @(s) s;
geom.qz = @(s) 0;
geom.nx = @(s) 1;
geom.ny = @(s) 0;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;


%% GEOMETRY NAME
geom.name = 'Ibend3D';

end