function geom = Wbend3D(geomparams)


%% PARAMETERS
%pre-bend straight length L1, post-bend straight length L2, bend radius and
% and angle R_B and theta_B, duct radius R_i
if ~exist('geomparams','var')
    geomparams.Lhat     = 5;
    geomparams.R_i      = 0.9;
    geomparams.Rhat     = 1;
    geomparams.thetahat = 3*pi/8;
end


Lhat        = geomparams.Lhat;
R_i         = geomparams.R_i;
Rhat        = geomparams.Rhat;
thetahat    = geomparams.thetahat;

L1W = (7+(Rhat-R_i)*cos(thetahat))/sin(thetahat);
% L1W = (Rhat+R_i)*tan(thetahat)*(1-sin(thetahat)) -(Rhat-R_i)*cos(thetahat);

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
s1W     = L1W;
s2W     = s1W + 2*Rhat*thetahat;
s3W     = s2W + Lhat;
s4W     = s3W + 2*Rhat*thetahat;
s5W     = s4W + Lhat;
s6W     = s5W + 2*Rhat*thetahat;
    function kappa = ductcurvature(s)
        if s > s1W && s <= s2W || s > s5W && s <= s6W
            kappa = -1/Rhat;
        elseif s > s3W && s <= s4W
            kappa = 1/Rhat;
        else
            kappa = 0;
        end
    end
geom.L      = s6W + L1W;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) ductcurvature(s);
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
    function x = ductpathx(s,parity,cl)
        if s <= s1W
            x = cl*(s*cos(thetahat) - Rhat*sin(thetahat)) ...
                + parity*sin(thetahat);
        elseif s > s1W && s <= s2W
            x = cl*(L1W*cos(thetahat) + Rhat*sin(thetahat)) ...
                - parity*sin(thetahat - (s - s1W)/Rhat);
        elseif s > s2W && s <= s3W
            x = cl*(L1W*cos(thetahat) + 3*Rhat*sin(thetahat)...
                + Lhat*cos(thetahat)*(s - s2W)/(s3W - s2W)) ...
                - parity*sin(thetahat);
        elseif s > s3W && s <= s4W
            x = cl*((L1W+Lhat)*cos(thetahat) + 3*Rhat*sin(thetahat))...
                - parity*sin(thetahat -(s - s3W)/Rhat);
        elseif s > s4W && s <= s5W
            x = cl*((L1W+Lhat)*cos(thetahat) + 3*Rhat*sin(thetahat)...
                + Lhat*cos(thetahat)*(s - s4W)/(s5W - s4W))...
                + parity*sin(thetahat);
        elseif s > s5W && s <= s6W
            x = cl*((L1W+2*Lhat)*cos(thetahat) + 5*Rhat*sin(thetahat))...
                - parity*sin(thetahat - (s - s5W)/Rhat);
        elseif s > s6W
            x = cl*((L1W+2*Lhat)*cos(thetahat) + 7*Rhat*sin(thetahat)...
                + L1W*cos(thetahat)*(s - s6W)/L1W) - parity*sin(thetahat);
        end
    end
    function y = ductpathy(s,parity,cl)
        if s <= s1W
            y = cl*(-s*sin(thetahat) - Rhat*cos(thetahat)) ...
                + parity*cos(thetahat);
        elseif s > s1W && s <= s2W
            y = cl*(-L1W*sin(thetahat) + Rhat*cos(thetahat)) ...
                - parity*cos(thetahat - (s - s1W)/Rhat);
        elseif s > s2W && s <= s3W
            y = cl*(-L1W*sin(thetahat) - Rhat*cos(thetahat)...
                + Lhat*sin(thetahat)*(s - s2W)/(s3W - s2W)) ...
                + parity*cos(thetahat);
        elseif s > s3W && s <= s4W
            y = cl*(-(L1W-Lhat)*sin(thetahat) - Rhat*cos(thetahat))...
                + parity*cos(thetahat -(s - s3W)/Rhat);
        elseif s > s4W && s <= s5W
            y = cl*(-(L1W-Lhat)*sin(thetahat) - Rhat*cos(thetahat)...
                - Lhat*sin(thetahat)*(s - s4W)/(s5W - s4W))...
                + parity*cos(thetahat);
        elseif s > s5W && s <= s6W
            y = cl*(-L1W*sin(thetahat) + Rhat*cos(thetahat)) ...
                - parity*cos(thetahat - (s - s5W)/Rhat);
        elseif s > s6W
            y = cl*(-L1W*sin(thetahat) - Rhat*cos(thetahat)...
                + L1W*sin(thetahat)*(s - s6W)/L1W) + parity*cos(thetahat);
        end
    end

geom.qx = @(s) ductpathx(s,Rhat,1);
geom.qy = @(s) ductpathy(s,Rhat,1);
geom.qz = @(s) 0;
geom.nx = @(s) ductpathx(s,-1 + 2*eq(sign(ductcurvature(s)),-1),0);
geom.ny = @(s) ductpathy(s,-1 + 2*eq(sign(ductcurvature(s)),-1),0);
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;


%% GEOMETRY NAME
geom.name = 'Wbend3D';

end