function geom = cubicnobend2D(geomparams)


%% PARAMETERS
%duct start width X_i, length s_o, decrease ratio > 1, curvature, bend
%radius R_B and bend angle theta_B
if ~exist('geomparams','var')
    geomparams.X_i      = 1;
    geomparams.s_o      = 3.275*geomparams.X_i;
    geomparams.ratio    = 4;
end

X_i     = geomparams.X_i;
s_o     = geomparams.s_o;
ratio   = geomparams.ratio;

geom.geomparams = geomparams;

%% SCALAR S-FUNCTIONS
    function X = ductradius(s)
        if s <= s_o
            X = X_i*(1 - 1/ratio)*(s/s_o)^2*(2*s/s_o - 3) + X_i;
        else
            X = X_i/ratio;
        end
    end
    function Xdash = ductradiusderiv(s)
        if s <= s_o
            Xdash = (6*X_i/s_o)*(1 - 1/ratio)*(s/s_o)*(s/s_o - 1);
        else
            Xdash = 0;
        end
    end
geom.L      = s_o;
geom.X      = @(s) ductradius(s);
geom.Xdash  = @(s) ductradiusderiv(s);
geom.Xpl    = @(s) 0.5*ductradius(s);
geom.Xpldash= @(s) 0.5*ductradiusderiv(s);
geom.Xmn    = @(s) -0.5*ductradius(s);
geom.Xmndash= @(s) -0.5*ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.qyvar  = true;
geom.dim    = 2;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'cubicnobend2D';

end