function geom = expplanarbend2D(geomparams)


%% PARAMETERS
%duct start width X_i, length s_o, decrease ratio > 1, curvature, bend
%radius R_B and bend angle theta_B
if ~exist('geomparams','var')
    geomparams.ratio    = 4;
    geomparams.X_i      = 1;
    geomparams.Xmn_i    = -geomparams.X_i/2;
    geomparams.s_o      = 4.5*geomparams.X_i;
    geomparams.kappa    = 0.2; %4/(5*geomparams.X_i);
end


ratio   = geomparams.ratio;
X_i     = geomparams.X_i;
s_o     = geomparams.s_o;
m       = -log(ratio)/(2*s_o);
kappa   = geomparams.kappa;
R_B     = 1/kappa;
theta_B = s_o/R_B;

geom.geomparams = geomparams;

%% SCALAR S-FUNCTIONS
    function X = ductradius(s)
        if s <= s_o
            X = X_i*exp(2*m*s);
        else
            X = ratio*X_i;
        end
    end
    function Xdash = ductradiusderiv(s)
        if s <= s_o
            Xdash = 2*m*X_i*exp(2*m*s);
        else
            Xdash = 0;
        end
    end
geom.L      = s_o;
geom.X      = @(s) ductradius(s);
geom.Xdash  = @(s) ductradiusderiv(s);
geom.Xpl    = @(s) 0.5*ductradius(s);
geom.Xpldash= @(s) 0.5*ductradiusderiv(s);
geom.Xmn    = @(s) -0.5*ductradius(s);
geom.Xmndash= @(s) -0.5*ductradiusderiv(s);
geom.kappa  = @(s) kappa;
geom.qyvar  = true;
geom.dim    = 2;


%% VECTOR S-FUNCTIONS
    function x = ductpathx(s,parity)
        x = parity*sin(kappa*s);
    end
    function y = ductpathy(s,parity,cl)
        y = (cl*R_B - parity*cos(kappa*s))...
            *sign(theta_B);
    end
    function x = innerductpathx(s,parity)
        x = -parity*sin(abs(theta_B) - kappa*s);
    end
    function y = innerductpathy(s,parity,cl)
        y = (cl*R_B - parity*cos(abs(theta_B) - kappa*s));
    end


geom.qx = @(s) ductpathx(s,R_B);
geom.qy = @(s) ductpathy(s,R_B,1);
geom.nx = @(s) ductpathx(s,-1);
geom.ny = @(s) ductpathy(s,-1,0);

geom.innerqx = @(s) innerductpathx(s,R_B);
geom.innerqy = @(s) innerductpathy(s,R_B,1);
geom.innernx = @(s) innerductpathx(s,-1);
geom.innerny = @(s) innerductpathy(s,-1,0);


%% GEOMETRY NAME
geom.name = 'expplanarbend2D';

end