function geom = helix3D(geomparams)


%% PARAMETERS
%number of rotations n, half-width R_i, curvature, torsion, helical radius
%a, helical length b, duct length s_o
if ~exist('geomparams','var')
%     n       = 4;
    geomparams.R_i     = 0.5;
    geomparams.kappa   = (2/3)/geomparams.R_i;
    geomparams.tau     = 0.2/geomparams.R_i;
    geomparams.s_o     = 3*2*pi*0.5/(0.95*1.8412);
%     geomparams.s_o     = 2*pi*geomparams.n...
%         /sqrt(geomparams.kappa^2 + geomparams.tau^2);
end

% n       = geomparams.n;
R_i     = geomparams.R_i;
kappa   = geomparams.kappa;
tau     = geomparams.tau;
a       = kappa/(kappa^2 + tau^2);
b       = tau/(kappa^2 + tau^2);
s_o     = geomparams.s_o;

geom.geomparams = geomparams;


%(self-intersection is prevented by: kappaR < pi/2 
% and tauR in [pi/2(1 - sqrt(1 - 4kappa^2/pi^2)), pi/2(1 + sqrt...]



%% SCALAR S-FUNCTIONS
geom.L      = s_o;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) kappa;
geom.tau    = @(s) tau;
geom.theta0 = @(s) tau*s;
geom.qyvar  = true;
geom.qzvar  = true;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) a*cos(sqrt(kappa^2 + tau^2)*s);
geom.qy = @(s) a*sin(sqrt(kappa^2 + tau^2)*s);
geom.qz = @(s) b*sqrt(kappa^2 + tau^2)*s;
geom.nx = @(s) -cos(sqrt(kappa^2 + tau^2)*s);
geom.ny = @(s) -sin(sqrt(kappa^2 + tau^2)*s);
geom.nz = @(s) 0;
geom.bx = @(s) sqrt(kappa^2 + tau^2)*b*sin(sqrt(kappa^2 + tau^2)*s);
geom.by = @(s) -sqrt(kappa^2 + tau^2)*b*cos(sqrt(kappa^2 + tau^2)*s);
geom.bz = @(s) sqrt(kappa^2 + tau^2)*a;


%% GEOMETRY NAME
geom.name = 'helix3D';

end