function geom = linrefltest3D(geomparams)


%% PARAMETERS
%duct length s_o, width decrease ratio < 1, inlet width R_i, decrease
%points s1 and s2
if ~exist('geomparams','var')
    geomparams.s_o     = 2;
    geomparams.ratio   = 1/2;
    geomparams.R_i     = 0.5;
    geomparams.s1      = 0.49*geomparams.s_o;
    geomparams.s2      = 0.51*geomparams.s_o;
end

s_o     = geomparams.s_o;
ratio   = geomparams.ratio;
R_i     = geomparams.R_i;
s1      = geomparams.s1;
s2      = geomparams.s2;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
    function R = ductradius(s)
        if s > s2
            R = R_i*ratio;
        elseif s <= s2 && s >= s1
            R = R_i + (ratio - 1)*R_i*(s - s1)/(s2 - s1);
        else
            R = R_i;
        end
    end
    function Rdash = ductradiusderiv(s)
        if s <= s2 && s >= s1
            Rdash = (ratio - 1)*R_i/(s2 - s1);
        else
            Rdash = 0;
        end
    end
geom.L      = s_o;
geom.R      = @(s) ductradius(s);
geom.Rdash  = @(s) ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.s_1    = s1;
geom.s_2    = s2;
geom.ratio  = ratio;
geom.qyvar  = false;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'linrefltest3D';

end