function geom = straighttrumpet3D(geomparams)


%% PARAMETERS
%duct length s_o, width change ratios 1 (< 1) and 2 (> 1)
if ~exist('geomparams','var')
    geomparams.s_o     = 1;
    geomparams.ratio1  = 1/2;
    geomparams.ratio2  = 8;
end

s_o     = geomparams.s_o;
ratio1  = geomparams.ratio1;
ratio2  = geomparams.ratio2;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
    function R = ductradius(s)
        if s < s_o && s >= 0.5*s_o
            R = exp(log(ratio2)*(2*s - 1))/ratio2;
        elseif s >= s_o
            R = 1;
        elseif s < 0.5*s_o && s >= 0.125*s_o
            R = 1/ratio2;
        elseif s < 0.125*s_o
            R = 1/ratio1*exp(-8*log(1/ratio1)*s)/ratio2;
        end
    end
    function Rdash = ductradiusderiv(s)
        if s < s_o && s >= 0.5*s_o
            Rdash = log(ratio2)*exp(log(ratio2)*(s-0.5))/ratio2;
        elseif s >= s_o
            Rdash = 0;
        elseif s < 0.5*s_o && s >= 0.125*s_o
            Rdash = 0;
        elseif s < 0.125*s_o
            Rdash=-8*1/ratio1*log(1/ratio1)*exp(-8*log(1/ratio1)*s)/ratio2;
        end
    end
geom.L      = s_o;
geom.R      = @(s) ductradius(s);
geom.Rdash  = @(s) ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = false;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'straighttrumpet3D';

end