function La = Ldefs2D(s,a,numparams,geom,lmats,Ltype)

% generates matrix blocks L1 L2 L3 L4 in 2D, given numerical and
% geometrical parameters

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
omega       = numparams.omega;


%% DUCT GEOMETRY
X_func      = geom().X;
Xdash_func  = geom().Xdash;
Xmn_func    = geom().Xmn;
Xmndash_func= geom().Xmndash;
kappa_func  = geom().kappa;

X       = X_func(s);
Xmn     = Xmn_func(s);

if Ltype == 0
    curv = true;
    Xvar = true;
elseif Ltype == 1
    curv = false;
    Xvar = false;
elseif Ltype == 2
    curv = true;
    Xvar = false;
else
    disp('error: specify Ltype')
end
if curv == true
    kappa = kappa_func(s);
else
    kappa = 0;
end
if Xvar == true
    Xdash = Xdash_func(s);
    Xmndash = Xmndash_func(s);
else
    Xdash = 0;
    Xmndash = 0;
end


%% LINEAR MATRIX DEFINITIONS
Isf         = eye(alpha_mx + 1);
Lambdasf    = lmats.Lambdasf;
Wsf         = lmats.Wsf;
Asf         = lmats.Asf;
Atilsf      = lmats.Atilsf;


%% L DEFINITION
La = zeros(2*(alpha_mx+1),2*(alpha_mx+1));
La(1:alpha_mx+1,1:alpha_mx+1) = -Xdash/(2*X)*Wsf - Xmndash/X*Atilsf;
La(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1)) = 1i*a*omega...
    *((Isf - (Lambdasf/(a*omega*X))^2)*((1 - kappa*Xmn)*Isf ...
    - kappa*X*Asf) - kappa*Atilsf/(a^2*omega^2*X));
La(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1) = ...
    1i*a*omega*((1 - kappa*Xmn)*Isf - kappa*X*Asf);
La(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1)) ...
    = Xdash/(2*X)*Wsf' + Xmndash/X*Atilsf';

end