function nlmats = calgen3D(modes)

% generates calligraphic tensors for projected 3D duct acoustics equations,
% given mode table

%% NUMERICAL DATA
alpha_mx = length(modes(:,1)) - 1;


%% NONLINEAR MATRIX DEFINITIONS
% 3D nonlinear building block matrices
PiPi        = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PiPi_x      = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PiPi_x2     = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PiPi_x_d    = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PiPi_x_b    = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PhiPhi      = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PhiPhi_cp   = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);
PhiPhi_d_sp = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1);

for gamma = 0:alpha_mx
    fprintf(1,'gamma = %3.0f\r', gamma);
    for beta = 0:alpha_mx
        for alpha = 0:alpha_mx
            PhiPhi(alpha+1,beta+1,gamma+1) = 0.5...
                *(eq(modes(alpha+1,3) + modes(beta+1,3) ...
                + modes(gamma+1,3),0) + (-1)^(modes(alpha+1,5))...
                *eq(modes(alpha+1,3),modes(beta+1,3)+modes(gamma+1,3)) ...
                + (-1)^(modes(beta+1,5))...
                *eq(modes(beta+1,3),modes(alpha+1,3)+modes(gamma+1,3)) ...
                + (-1)^(modes(gamma+1,5))...
                *eq(modes(gamma+1,3),modes(alpha+1,3)+modes(beta+1,3)))*...
                (eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),0)...
                - eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),2));
            PhiPhi_cp(alpha+1,beta+1,gamma+1) = 0.25*...
                (eq(modes(alpha+1,3)+modes(beta+1,3)+modes(gamma+1,3),1)...
                + (-1)^(modes(alpha+1,5))...
                *eq(abs(modes(beta+1,3) + modes(gamma+1,3) ...
                - modes(alpha+1,3)),1) + (-1)^(modes(beta+1,5))...
                *eq(abs(modes(alpha+1,3) + modes(gamma+1,3) ...
                - modes(beta+1,3)),1) + (-1)^(modes(gamma+1,5))...
                *eq(abs(modes(alpha+1,3) + modes(beta+1,3) ...
                - modes(gamma+1,3)),1))*...
                (eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),0)...
                - eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),2));
            PhiPhi_d_sp(alpha+1,beta+1,gamma+1)=-modes(alpha+1,3)/4*...
                (eq(modes(alpha+1,3)+modes(beta+1,3)+modes(gamma+1,3),1)...
                + (-1)^(modes(beta+1,3) + modes(gamma+1,3) ...
                - modes(alpha+1,3) + modes(alpha+1,5))...
                *eq(abs(modes(beta+1,3) + modes(gamma+1,3) ...
                - modes(alpha+1,3)),1) ...
                + (-1)^(modes(alpha+1,3) + modes(gamma+1,3) ...
                - modes(beta+1,3) + modes(beta+1,5))...
                *eq(abs(modes(alpha+1,3) + modes(gamma+1,3) ...
                - modes(beta+1,3)),1) ...
                + (-1)^(modes(alpha+1,3) + modes(beta+1,3) ...
                - modes(gamma+1,3) + modes(gamma+1,5))...
                *eq(abs(modes(alpha+1,3) + modes(beta+1,3) ...
                - modes(gamma+1,3)),1))*...
                (eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),0)...
                - eq(modes(alpha+1,5)+modes(beta+1,5)+modes(gamma+1,5),2));
            if PhiPhi(alpha+1,beta+1,gamma+1) ~= 0 ...
                || PhiPhi_cp(alpha+1,beta+1,gamma+1) ~= 0 ...
                || PhiPhi_d_sp(alpha+1,beta+1,gamma+1) ~= 0
                PiPi_x_b(alpha+1,beta+1,gamma+1) = modes(alpha+1,6)...
                    *modes(beta+1,6)*modes(gamma+1,6)...
                    *besselj(modes(alpha+1,3),modes(alpha+1,2))...
                    *besselj(modes(beta+1,3),modes(beta+1,2))...
                    *besselj(modes(gamma+1,3),modes(gamma+1,2));
            end
            if PhiPhi(alpha+1,beta+1,gamma+1) ~= 0
                PiPi_x(alpha+1,beta+1,gamma+1) = modes(alpha+1,6)...
                    *modes(beta+1,6)*modes(gamma+1,6)*integral(@(x) x...
                    .*besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                    .*besselj(modes(beta+1,3),modes(beta+1,2).*x)...
                    .*besselj(modes(gamma+1,3),modes(gamma+1,2).*x),0,1);
            end
            if PhiPhi_cp(alpha+1,beta+1,gamma+1) ~= 0
                PiPi_x2(alpha+1,beta+1,gamma+1) = modes(alpha+1,6)*...
                    modes(beta+1,6)*modes(gamma+1,6)*integral(@(x) x.^2 ...
                    .*besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                    .*besselj(modes(beta+1,3),modes(beta+1,2).*x)...
                    .*besselj(modes(gamma+1,3),modes(gamma+1,2).*x),0,1);
                PiPi_x_d(alpha+1,beta+1,gamma+1) = modes(alpha+1,6)...
                    *modes(beta+1,6)*modes(gamma+1,6)*integral(@(x)...
                    (modes(alpha+1,3)...
                    *besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                    - modes(alpha+1,2).*x...
                    .*besselj(modes(alpha+1,3)+1,modes(alpha+1,2).*x))...
                    .*besselj(modes(beta+1,3),modes(beta+1,2).*x)...
                    .*besselj(modes(gamma+1,3),modes(gamma+1,2).*x),0,1);
            end
            if PhiPhi_d_sp(alpha+1,beta+1,gamma+1) ~= 0
                PiPi(alpha+1,beta+1,gamma+1) = modes(alpha+1,6)...
                    *modes(beta+1,6)*modes(gamma+1,6)*integral(@(x)...
                    besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                    .*besselj(modes(beta+1,3),modes(beta+1,2).*x)...
                    .*besselj(modes(gamma+1,3),modes(gamma+1,2).*x)...
                    ,0,1);
            end
        end
    end
end

Ical        = PiPi_x.*PhiPhi;
Wbarcal     = PiPi_x_b.*PhiPhi;
Acal        = PiPi_x2.*PhiPhi_cp;
Atilcal     = PiPi_x_d.*PhiPhi_cp - PiPi.*PhiPhi_d_sp;
Abarcal     = PiPi_x_b.*PhiPhi_cp;
Abarstarcal = PiPi_x_b.*PhiPhi_d_sp;

Lambdasf    = diag(modes(:,2));
Psf         = diag(modes(:,3));
IEcal       = 0.5*(permute(tensorprod(Ical,Lambdasf,2,1),[1 3 2]) ...
                + tensorprod(Ical,Lambdasf,3,1) ...
                - tensorprod(Lambdasf,Ical,2,1));
AEcal       = 0.5*(permute(tensorprod(Acal,Lambdasf,2,1),[1 3 2]) ...
                + tensorprod(Acal,Lambdasf,3,1) ...
                - tensorprod(Lambdasf,Acal,2,1)) + Atilcal - 0.5*Abarcal;
AtilEcal    = 0.5*(permute(tensorprod(Atilcal,Lambdasf,2,1),[1 3 2]) ...
                + tensorprod(Atilcal,Lambdasf,3,1) ...
                - tensorprod(Lambdasf,Atilcal,2,1) ...
                + tensorprod(Lambdasf^2 - Psf^2,Abarcal,2,1) ...
                - Abarstarcal);

nlmats.Ical     = Ical;
nlmats.Wbarcal  = Wbarcal;
nlmats.Acal     = Acal;
nlmats.Atilcal  = Atilcal;
nlmats.IEcal    = IEcal;
nlmats.AEcal    = AEcal;
nlmats.AtilEcal = AtilEcal;

end
