function dYsf_ds_pos = dYsf_ds_def(s,Ysfsol_pos,numparams,geom,lmats)

% defines matrix d(Ysf)ds at a point s in the duct, given numerical and 
% geometrical parameters

% fprintf(1,'s = %6.3f\r', s);

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;

%matrix multiplication requires column vector to become matrix
Ysfsol_pos  = reshape(Ysfsol_pos,[alpha_mx+1,alpha_mx+1,a_mx]);
dYsf_ds_pos = zeros(alpha_mx + 1,alpha_mx + 1, a_mx);

for a = 1:a_mx
    if geom.dim == 2
        Lsf = Ldefs2D(s,a,numparams,geom,lmats,0);
    elseif geom.dim == 3
        Lsf = Ldefs3D(s,a,numparams,geom,lmats,0);
    end
    Lsf1 = Lsf(1:alpha_mx+1,1:alpha_mx+1);
    Lsf2 = Lsf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1));
    Lsf3 = Lsf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1);
    Lsf4 = Lsf(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1));
    dYsf_ds_pos(:,:,a) = -Ysfsol_pos(:,:,a)*Lsf3*Ysfsol_pos(:,:,a) ...
        + Lsf1*Ysfsol_pos(:,:,a) - Ysfsol_pos(:,:,a)*Lsf4 + Lsf2;
end

%convert back to column vector
dYsf_ds_pos = reshape(dYsf_ds_pos,[a_mx*(alpha_mx + 1)^2,1]);

end