function charmats = evaluefinder(s,numparams,geom,lmats,nlmats,Ltype)

% defines characteristic admittances at a point s in the duct, given
% numerical and geometrical parameters

% can give straight, curved, or torsional characteristic admittances
% Ltype = 1 for Ybar, 2 for Ybreve, 3 (or o/w) for Ytilde


%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
nonlinear   = numparams.nonlinear;
omega       = numparams.omega;


%% GEOMETRY
kappa   = geom().kappa(s);
dim     = geom().dim;
if dim == 2
    tau = 0;
elseif dim == 3
    tau     = geom().tau(s);
end


%% CHARACTERISTIC MATRICES
Ysf_pos         = zeros(alpha_mx+1,alpha_mx+1,a_mx);
Ysfpl_pos       = zeros(alpha_mx+1,alpha_mx+1,a_mx);
Ysfmn_pos       = zeros(alpha_mx+1,alpha_mx+1,a_mx);
Gammasf_pos     = zeros(alpha_mx+1,alpha_mx+1,a_mx);
Lsf_pos         = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
cutoff_pos      = zeros(alpha_mx+1,alpha_mx+1,a_mx);

if kappa == 0 || Ltype == 1
    for a = 1:a_mx
        if dim == 2
            Lsf_pos(:,:,a) = Ldefs2D(s,a,numparams,geom,lmats,1);
        elseif dim == 3
            Lsf_pos(:,:,a) = Ldefs3D(s,a,numparams,geom,lmats,1);
        end
        cutoff_pos(:,:,a)   = Lsf_pos(1:alpha_mx+1,...
            alpha_mx+2:2*alpha_mx+2,a)/(1i*a*omega);
        for alpha = 0:alpha_mx
            Ysf_pos(alpha+1,alpha+1,a) ...
                = exp(-0.25*1i*pi*(sign(cutoff_pos(alpha+1,alpha+1,a))...
                - 1))*sqrt(abs(cutoff_pos(alpha+1,alpha+1,a)));
        end
        Gammasf_pos(:,:,a) = 1i*a*omega*Ysf_pos(:,:,a);
    end
    Ysfpl_pos = Ysf_pos;
    Ysfmn_pos = -Ysf_pos;
    if nonlinear == true
        Gammasf   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Ysf(:,:,a_mx+2:2*a_mx+1)        = Ysf_pos(:,:,1:a_mx);
        Gammasf(:,:,a_mx+2:2*a_mx+1)    = Gammasf_pos(:,:,1:a_mx);
        Ysf(:,:,a_mx:-1:1)              = conj(Ysf_pos(:,:,1:a_mx));
        Gammasf(:,:,a_mx:-1:1)          = conj(Gammasf_pos(:,:,1:a_mx));
        Ycal_pos = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
        for a = 1:a_mx
            for b = -a_mx+a:a_mx
                if b ~= 0 && b ~= a
                    if dim == 2
                        Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,...
                            nlmats,1);
                    elseif dim == 3
                        Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,...
                            nlmats,1);
                    end
                    Ncal1 = Ncal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
                    Ncal6 = Ncal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                        alpha_mx+2:2*(alpha_mx+1));
                    Ncal7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        alpha_mx+2:2*(alpha_mx+1));
                    Fcal = tensorprod(tensorprod(Ncal1,...
                        Ysf(:,:,a-b+a_mx+1),2,1),...
                        Ysf(:,:,b+a_mx+1),2,1) ...
                        + Ncal6 - permute(tensorprod(tensorprod(...
                        Ysf(:,:,a+a_mx+1),Ncal7,2,1),...
                        Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]);
                    evals = repmat(diag(Gammasf(:,:,a+a_mx+1)),1,...
                        alpha_mx+1,alpha_mx+1) ...
                        + permute(repmat(diag(Gammasf(:,:,...
                        a-b+a_mx+1)),1,alpha_mx+1,alpha_mx+1),[3 1 2])...
                        + permute(repmat(diag(Gammasf(:,:,b+a_mx+1)),...
                        1,alpha_mx+1,alpha_mx+1),[2 3 1]);
                    zeroer = ones(alpha_mx+1,alpha_mx+1,alpha_mx+1);
                    for alpha = 0:alpha_mx
                        for beta = 0:alpha_mx
                            for gamma = 0:alpha_mx
                                if evals(alpha+1,beta+1,gamma+1) == 0
                                    disp('resonant triad (plus)!')
                                    disp(alpha)
                                    disp(beta)
                                    disp(gamma)
                                    disp(a)
                                    disp(b)
                                    zeroer(alpha+1,beta+1,gamma+1) = 0;
                                    evals(alpha+1,beta+1,gamma+1) = 1;
                                end
                            end
                        end
                    end
                    evdenom = zeroer.*evals.^-1;
                    Ycal_pos(:,:,:,a,b+a_mx+1) = Fcal.*evdenom;
                end
            end
        end
        Ysfpl       = Ysf;
        Ysfmn       = -Ysf;
        Ycalpl_pos  = Ycal_pos;
        Ycalmn_pos  = -Ycal_pos;
    end
elseif kappa ~= 0 && tau == 0 || Ltype == 2
    Lsf2_pos    = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Lsf3_pos    = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Gammasf_pos = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Csf_pos     = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    for a = 1:a_mx
        if dim == 2
            Lsf_pos(:,:,a) = Ldefs2D(s,a,numparams,geom,lmats,2);
        elseif dim == 3
            Lsf_pos(:,:,a) = Ldefs3D(s,a,numparams,geom,lmats,2);
        end
        Lsf2_pos(:,:,a)     = Lsf_pos(1:alpha_mx+1,...
            alpha_mx+2:2*alpha_mx+2,a);
        Lsf3_pos(:,:,a)     = Lsf_pos(alpha_mx+2:2*alpha_mx+2,...
            1:alpha_mx+1,a);
        [Csf_pos(:,:,a),Gammasf2_pos] ...
            = eig(Lsf3_pos(:,:,a)*Lsf2_pos(:,:,a));
        for alpha = 0:alpha_mx
            if Gammasf2_pos(alpha+1,alpha+1) > 0
                Gammasf_pos(alpha+1,alpha+1,a) ...
                    = -sqrt(abs(Gammasf2_pos(alpha+1,alpha+1)));
            elseif Gammasf2_pos(alpha+1,alpha+1) == 0
                Gammasf_pos(alpha+1,alpha+1,a) = 0;
            else
                Gammasf_pos(alpha+1,alpha+1,a) ...
                    = 1i*sqrt(abs(Gammasf2_pos(alpha+1,alpha+1)));
            end
        end
        Ysf_pos(:,:,a) = Lsf3_pos(:,:,a)\Csf_pos(:,:,a)...
            *Gammasf_pos(:,:,a)/Csf_pos(:,:,a);
    end
    Ysfpl_pos = Ysf_pos;
    Ysfmn_pos = -Ysf_pos;
    if nonlinear == true
        Gammasf     = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csf         = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csf_inv     = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);

        Ysf(:,:,a_mx+2:2*a_mx+1)        = Ysf_pos(:,:,1:a_mx);
        Gammasf(:,:,a_mx+2:2*a_mx+1)    = Gammasf_pos(:,:,1:a_mx);
        Csf(:,:,a_mx + 2:2*a_mx+1)      = Csf_pos(:,:,1:a_mx);
        Ysf(:,:,a_mx:-1:1)              = conj(Ysf_pos(:,:,1:a_mx));
        Gammasf(:,:,a_mx:-1:1)          = conj(Gammasf_pos(:,:,1:a_mx));
        Csf(:,:,a_mx:-1:1)              = conj(Csf_pos(:,:,1:a_mx));
        for a = 1:a_mx
            Csf_inv(:,:,a_mx+1+a)   = inv(Csf(:,:,a_mx+1+a));
            Csf_inv(:,:,a_mx+1-a)   = conj(Csf_inv(:,:,a_mx+1+a));
        end
        Ycal_pos = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
        for a = 1:a_mx
            for b = -a_mx+a:a_mx
                if b ~= 0 && b ~= a
                    if dim == 2
                        Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,...
                            nlmats,2);
                    elseif dim == 3
                        Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,...
                            nlmats,2);
                    end
                    Ncal1 = Ncal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
                    Ncal6 = Ncal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                        alpha_mx+2:2*(alpha_mx+1));
                    Ncal7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        alpha_mx+2:2*(alpha_mx+1));
                    Fcal = tensorprod(tensorprod(Ncal1,...
                        Ysf(:,:,a-b+a_mx+1),2,1),...
                        Ysf(:,:,b+a_mx+1),2,1) + Ncal6 ...
                        - permute(tensorprod(tensorprod(...
                        Ysf(:,:,a+a_mx+1),Ncal7,2,1),...
                        Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]);
                    evals = repmat(diag(Gammasf(:,:,a+a_mx+1)),1,...
                        alpha_mx+1,alpha_mx+1) ...
                        + permute(repmat(diag(Gammasf(:,:,...
                        a-b+a_mx+1)),1,alpha_mx+1,alpha_mx+1),[3 1 2])...
                        + permute(repmat(diag(Gammasf(:,:,b+a_mx+1)),...
                        1,alpha_mx+1,alpha_mx+1),[2 3 1]);
                    zeroer = ones(alpha_mx+1,alpha_mx+1,alpha_mx+1);
                    for alpha = 0:alpha_mx
                        for beta = 0:alpha_mx
                            for gamma = 0:alpha_mx
                                if evals(alpha+1,beta+1,gamma+1) == 0
                                    disp('resonant triad (plus)!')
                                    disp(alpha)
                                    disp(beta)
                                    disp(gamma)
                                    disp(a)
                                    disp(b)
                                    zeroer(alpha+1,beta+1,gamma+1) = 0;
                                    evals(alpha+1,beta+1,gamma+1) = 1;
                                end
                            end
                        end
                    end
                    evdenom = zeroer.*evals.^-1;
                    Ycaltil = tensorprod(tensorprod(tensorprod(...
                        Csf(:,:,a+a_mx+1).',Fcal,2,1),...
                        Csf(:,:,a-b+a_mx+1),2,1),...
                        Csf(:,:,b+a_mx+1),2,1).*evdenom;
                    Ycal_pos(:,:,:,a,b+a_mx+1)...
                        = tensorprod(tensorprod(tensorprod(...
                        Csf_inv(:,:,a+a_mx+1).',Ycaltil,2,1),...
                        Csf_inv(:,:,a-b+a_mx+1),2,1),...
                        Csf_inv(:,:,b+a_mx+1),2,1);
                end
            end
        end
        Ysfpl       = Ysf;
        Ysfmn       = -Ysf;
        Ycalpl_pos  = Ycal_pos;
        Ycalmn_pos  = -Ycal_pos;
    end
else
    straightLsf_pos     = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
    epsilon_a           = zeros(1,a_mx);
    Lsf1_pos            = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Lsf2_pos            = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Lsf3_pos            = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Lsf4_pos            = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    fullCsf_pos         = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
    fullGammasf_pos     = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
    Gammasfpl_pos       = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Gammasfmn_pos       = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Csfpl_pos           = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    Csfmn_pos           = zeros(alpha_mx+1,alpha_mx+1,a_mx);
    zeroGammasfpl_pos   = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
    zeroGammasfmn_pos   = zeros(2*alpha_mx+2,2*alpha_mx+2,a_mx);
    zeroCsfpl_pos       = zeros(alpha_mx+1,2*alpha_mx+2,a_mx);
    zeroCsfmn_pos       = zeros(alpha_mx+1,2*alpha_mx+2,a_mx);
    for a = 1:a_mx
        if dim == 2
            Lsf_pos(:,:,a) = Ldefs2D(s,a,numparams,geom,lmats,3);
            straightLsf_pos(:,:,a) ...
                = Ldefs2D(s,a,numparams,geom,lmats,1);
        elseif dim == 3
            Lsf_pos(:,:,a) = Ldefs3D(s,a,numparams,geom,lmats,3);
            straightLsf_pos(:,:,a) ...
                = Ldefs3D(s,a,numparams,geom,lmats,1);
        end
        Lsf1_pos(:,:,a)     = Lsf_pos(1:alpha_mx+1,1:alpha_mx+1,a);
        Lsf2_pos(:,:,a)     = Lsf_pos(1:alpha_mx+1,...
            alpha_mx+2:2*alpha_mx+2,a);
        Lsf3_pos(:,:,a)     = Lsf_pos(alpha_mx+2:2*alpha_mx+2,...
            1:alpha_mx+1,a);
        Lsf4_pos(:,:,a)     = Lsf_pos(alpha_mx+2:2*alpha_mx+2,...
            alpha_mx+2:2*alpha_mx+2,a);
        cutoff_pos(:,:,a)   = straightLsf_pos(1:alpha_mx+1,...
            alpha_mx+2:2*alpha_mx+2,a);
        epsilon_a(a)        = min(diag(abs(cutoff_pos(:,:,a))),[],'all');
        [fullCsf_pos(:,:,a),fullGammasf_pos(:,:,a)] = eig(Lsf_pos(:,:,a));
        neg0count   = 0;
        negcount    = 0;
        pos0count   = 0;
        poscount    = 0;
        zerocount   = 0;
        for alpha = 0:2*alpha_mx+1
            if real(fullGammasf_pos(alpha+1,alpha+1,a)) ...
                    < -epsilon_a(a)/10
                negcount = negcount+1;
                Gammasfpl_pos(negcount,negcount,a) ...
                    = fullGammasf_pos(alpha+1,alpha+1,a);
                Csfpl_pos(:,negcount,a) = fullCsf_pos(...
                    alpha_mx+2:2*alpha_mx+2,alpha+1,a);
            elseif imag(fullGammasf_pos(alpha+1,alpha+1,a))>0 ...
                    && abs(real(fullGammasf_pos(...
                    alpha+1,alpha+1,a))) <= epsilon_a(a)/10
                pos0count = pos0count+1;
                zeroGammasfpl_pos(pos0count,pos0count,a) ...
                    = fullGammasf_pos(alpha+1,alpha+1,a);
                zeroCsfpl_pos(:,pos0count,a) = fullCsf_pos(...
                    alpha_mx+2:2*alpha_mx+2,alpha+1,a);
            elseif real(fullGammasf_pos(alpha+1,alpha+1,a)) ...
                    > epsilon_a(a)/10
                poscount = poscount+1;
                Gammasfmn_pos(poscount,poscount,a) ...
                    = fullGammasf_pos(alpha+1,alpha+1,a);
                Csfmn_pos(:,poscount,a) = fullCsf_pos(...
                    alpha_mx+2:2*alpha_mx+2,alpha+1,a);
            elseif imag(fullGammasf_pos(alpha+1,alpha+1,a))<0 ...
                    && abs(real(fullGammasf_pos(...
                    alpha+1,alpha+1,a))) <= epsilon_a(a)/10
                neg0count = neg0count+1;
                zeroGammasfmn_pos(neg0count,neg0count,a) ...
                    = fullGammasf_pos(alpha+1,alpha+1,a);
                zeroCsfmn_pos(:,neg0count,a) = fullCsf_pos(...
                    alpha_mx+2:2*alpha_mx+2,alpha+1,a);
            else
                zerocount = zerocount+1;
            end
        end
        if negcount+pos0count == alpha_mx+1
            for alpha = 0:alpha_mx - negcount
                Gammasfpl_pos(negcount+alpha+1,negcount+alpha+1,...
                    a) = zeroGammasfpl_pos(alpha+1,alpha+1,a);
                Csfpl_pos(:,negcount+alpha+1,a) ...
                    = zeroCsfpl_pos(:,alpha+1,a);
            end
            Ysfpl_pos(:,:,a) ...
                = Lsf3_pos(:,:,a)\(Csfpl_pos(:,:,a)...
                *Gammasfpl_pos(:,:,a)/Csfpl_pos(:,:,a) ...
                - Lsf4_pos(:,:,a));
        else
            disp('error in eigenvalue selection')
            disp(negcount)
            disp(pos0count)
            disp(alpha_mx+1)
        end
        if poscount+neg0count == alpha_mx+1
            for alpha = 0:alpha_mx - poscount
                Gammasfmn_pos(poscount+alpha+1,poscount+alpha+1,...
                    a) = zeroGammasfmn_pos(alpha+1,alpha+1,a);
                Csfmn_pos(:,poscount+alpha+1,a) ...
                    = zeroCsfmn_pos(:,alpha+1,a);
            end
            Ysfmn_pos(:,:,a) ...
                = Lsf3_pos(:,:,a)\(Csfmn_pos(:,:,a)...
                *Gammasfmn_pos(:,:,a)/Csfmn_pos(:,:,a) ...
                - Lsf4_pos(:,:,a));
        else
            disp('error in eigenvalue selection')
            disp(negcount)
            disp(pos0count)
            disp(alpha_mx+1)
        end
    end
    if nonlinear == true
        Gammasfpl   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Gammasfmn   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csfpl       = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csfmn       = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csfpl_inv   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
        Csfmn_inv   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);

        Ysfpl(:,:,a_mx+2:2*a_mx+1)      = Ysfpl_pos(:,:,1:a_mx);
        Ysfmn(:,:,a_mx+2:2*a_mx+1)      = Ysfmn_pos(:,:,1:a_mx);
        Gammasfpl(:,:,a_mx+2:2*a_mx+1)  = Gammasfpl_pos(:,:,1:a_mx);
        Gammasfmn(:,:,a_mx+2:2*a_mx+1)  = Gammasfmn_pos(:,:,1:a_mx);
        Csfpl(:,:,a_mx + 2:2*a_mx+1)    = Csfpl_pos(:,:,1:a_mx);
        Csfmn(:,:,a_mx + 2:2*a_mx+1)    = Csfmn_pos(:,:,1:a_mx);
        Ysfpl(:,:,a_mx:-1:1)            = conj(Ysfpl_pos(:,:,1:a_mx));
        Ysfmn(:,:,a_mx:-1:1)            = conj(Ysfmn_pos(:,:,1:a_mx));
        Gammasfpl(:,:,a_mx:-1:1)        = conj(Gammasfpl_pos(:,:,1:a_mx));
        Gammasfmn(:,:,a_mx:-1:1)        = conj(Gammasfmn_pos(:,:,1:a_mx));
        Csfpl(:,:,a_mx:-1:1)            = conj(Csfpl_pos(:,:,1:a_mx));
        Csfmn(:,:,a_mx:-1:1)            = conj(Csfmn_pos(:,:,1:a_mx));
        for a = 1:a_mx
            Csfpl_inv(:,:,a_mx+1+a) = inv(Csfpl(:,:,a_mx+1+a));
            Csfpl_inv(:,:,a_mx+1-a) = conj(Csfpl_inv(:,:,a_mx+1+a));
            Csfmn_inv(:,:,a_mx+1+a) = inv(Csfmn(:,:,a_mx+1+a));
            Csfmn_inv(:,:,a_mx+1-a) = conj(Csfmn_inv(:,:,a_mx+1+a));
        end
        Ycalpl_pos = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
        Ycalmn_pos = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
        for a = 1:a_mx
            for b = -a_mx+a:a_mx
                if b ~= 0 && b ~= a
                    if dim == 2
                        Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,...
                            nlmats,3);
                    elseif dim == 3
                        Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,...
                            nlmats,3);
                    end
                    Ncal1 = Ncal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
                    Ncal6 = Ncal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                        alpha_mx+2:2*(alpha_mx+1));
                    Ncal7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        alpha_mx+2:2*(alpha_mx+1));
                    Fcalpl = tensorprod(tensorprod(Ncal1,...
                        Ysfpl(:,:,a-b+a_mx+1),2,1),...
                        Ysfpl(:,:,b+a_mx+1),2,1) ...
                        + Ncal6 - permute(tensorprod(tensorprod(...
                        Ysfpl(:,:,a+a_mx+1),Ncal7,2,1),...
                        Ysfpl(:,:,a-b+a_mx+1),2,1),[1 3 2]);
                    Fcalmn = tensorprod(tensorprod(Ncal1,...
                        Ysfmn(:,:,a-b+a_mx+1),2,1),...
                        Ysfmn(:,:,b+a_mx+1),2,1) ...
                        + Ncal6 - permute(tensorprod(tensorprod(...
                        Ysfmn(:,:,a+a_mx+1),...
                        Ncal7,2,1),Ysfmn(:,:,a-b+a_mx+1),2,1),[1 3 2]);
                    evalspl = repmat(diag(Gammasfpl(:,:,a+a_mx+1)),1,...
                        alpha_mx+1,alpha_mx+1) ...
                        + permute(repmat(diag(Gammasfpl(:,:,...
                        a-b+a_mx+1)),1,alpha_mx+1,alpha_mx+1),[3 1 2])...
                        + permute(repmat(diag(Gammasfpl(:,:,b+a_mx+1)),...
                        1,alpha_mx+1,alpha_mx+1),[2 3 1]);
                    evalsmn = repmat(diag(Gammasfmn(:,:,a+a_mx+1)),1,...
                        alpha_mx+1,alpha_mx+1) ...
                        + permute(repmat(diag(Gammasfmn(:,:,...
                        a-b+a_mx+1)),1,alpha_mx+1,alpha_mx+1),[3 1 2]) ...
                        + permute(repmat(diag(Gammasfmn(:,:,b+a_mx+1)),...
                        1,alpha_mx+1,alpha_mx+1),[2 3 1]);
                    zeroerpl = ones(alpha_mx+1,alpha_mx+1,alpha_mx+1);
                    zeroermn = ones(alpha_mx+1,alpha_mx+1,alpha_mx+1);
                    for alpha = 0:alpha_mx
                        for beta = 0:alpha_mx
                            for gamma = 0:alpha_mx
                                if evalspl(alpha+1,beta+1,gamma+1) == 0
                                    disp('resonant triad (plus)!')
                                    disp(alpha)
                                    disp(beta)
                                    disp(gamma)
                                    disp(a)
                                    disp(b)
                                    zeroerpl(alpha+1,beta+1,gamma+1) = 0;
                                    evalspl(alpha+1,beta+1,gamma+1) = 1;
                                end
                                if evalsmn(alpha+1,beta+1,gamma+1) == 0
                                    disp('resonant triad (minus)!')
                                    disp(alpha)
                                    disp(beta)
                                    disp(gamma)
                                    disp(a)
                                    disp(b)
                                    zeroermn(alpha+1,beta+1,gamma+1) = 0;
                                    evalsmn(alpha+1,beta+1,gamma+1) = 1;
                                end
                            end
                        end
                    end
                    evdenompl = zeroerpl.*evalspl.^-1;
                    evdenommn = zeroermn.*evalsmn.^-1;
                    Ycaltilpl = tensorprod(tensorprod(tensorprod(...
                        Csfpl(:,:,a+a_mx+1).',Fcalpl,2,1),...
                        Csfpl(:,:,a-b+a_mx+1),2,1),...
                        Csfpl(:,:,b+a_mx+1),2,1).*evdenompl;
                    Ycaltilmn = tensorprod(tensorprod(tensorprod(...
                        Csfmn(:,:,a+a_mx+1).',Fcalmn,2,1),...
                        Csfmn(:,:,a-b+a_mx+1),2,1),...
                        Csfmn(:,:,b+a_mx+1),2,1).*evdenommn;
                    Ycalpl_pos(:,:,:,a,b+a_mx+1)...
                        = tensorprod(tensorprod(tensorprod(...
                        Csfpl_inv(:,:,a+a_mx+1).',Ycaltilpl,2,1),...
                        Csfpl_inv(:,:,a-b+a_mx+1),2,1),...
                        Csfpl_inv(:,:,b+a_mx+1),2,1);
                    Ycalmn_pos(:,:,:,a,b+a_mx+1)...
                        = tensorprod(tensorprod(tensorprod(...
                        Csfmn_inv(:,:,a+a_mx+1).',Ycaltilmn,2,1),...
                        Csfmn_inv(:,:,a-b+a_mx+1),2,1),...
                        Csfmn_inv(:,:,b+a_mx+1),2,1);
                end
            end
        end
    end
end


charmats.Ysfpl_pos = Ysfpl_pos;
charmats.Ysfmn_pos = Ysfmn_pos;
charmats.Gammasf_pos = Gammasf_pos;
if nonlinear == true
    charmats.Ysfpl  = Ysfpl;
    charmats.Ysfmn  = Ysfmn;
    charmats.Ycalpl_pos = Ycalpl_pos;
    charmats.Ycalmn_pos = Ycalmn_pos;
end
end