function modes = pqxigen3D(p_mx,q_mx,xi_mx)

%generates 3D mode array given maximum values of p, q and xi

%% BESSEL DERIVATIVE ZEROES
p           = 0:p_mx;
q           = 1:q_mx;
alpha_mx    = ((xi_mx + 1)*p_mx + 1)*q_mx;
[Jdash0s,n] = sort(reshape(transpose(BessDerivZerosBisect2(p,q)),[],1));


%% P AND Q VALUES
rowindex = mod(n,q_mx);
for row = 1:size(rowindex,1)
    if rowindex(row) == 0
        rowindex(row) = rowindex(row) + q_mx;
    end
end
columnindex = ceil(n/(q_mx)) - 1;

modes = zeros(alpha_mx + 1,6);
if xi_mx == 0
    modes(2:alpha_mx+1,2) = Jdash0s;
    modes(2:alpha_mx+1,3) = columnindex;
    modes(2:alpha_mx+1,4) = rowindex;
elseif xi_mx == 1
    %count degeneracies
    degcount = 0;
    for alpha = 0:q_mx*(p_mx+1) - 1
        if columnindex(alpha+1) ~= 0
            % eigenvalue
            modes(alpha+2+degcount,2)   = Jdash0s(alpha+1);
            modes(alpha+3+degcount,2)   = Jdash0s(alpha+1);
            % azimuthal mode number
            modes(alpha+2+degcount,3)   = columnindex(alpha+1);
            modes(alpha+3+degcount,3)   = columnindex(alpha+1);
            % bessel derivative number
            modes(alpha+2+degcount,4)   = rowindex(alpha+1);
            modes(alpha+3+degcount,4)   = rowindex(alpha+1);
            % xi index
            modes(alpha+3+degcount,5)   = 1;
            degcount                    = degcount + 1;
        elseif columnindex(alpha+1) == 0
            modes(alpha+2+degcount,2)   = Jdash0s(alpha+1);
            modes(alpha+2+degcount,3)   = 0;
            modes(alpha+2+degcount,4)   = rowindex(alpha+1);
        end
    end
else 
    disp('error: invalid xi_max value (must be 0 or 1)')
end

% modenumber
modes(:,1) = 0:alpha_mx;


%% MODE NORMALISATION CONSTANTS
for alpha = 0:alpha_mx
    if modes(alpha+1,3) == 0
        modes(alpha+1,6) = 1/(abs(besselj(0,modes(alpha+1,2))));
    else
        modes(alpha+1,6) ...
            = 1/(sqrt(0.5*(1 -(modes(alpha+1,3)/modes(alpha+1,2))^2))...
            *abs(besselj(modes(alpha+1,3),modes(alpha+1,2))));
    end
end

end