function lmats = sfgen2D(modes)

% generates sans-serif matrices for projected 2D duct acoustics equations,
% given mode table

%% NUMERICAL DATA
alpha_mx = length(modes(:,1)) - 1;


%% LINEAR MATRIX DEFINITIONS
% 2D linear building-block matrices
Xi_xi       = zeros(alpha_mx+1);
Xi_d        = zeros(alpha_mx+1);
Xi_xi_d     = zeros(alpha_mx+1);
for beta = 0:alpha_mx
    fprintf(1,'beta = %3.0f\r', beta);
    for alpha = 0:alpha_mx
        if alpha == beta
            Xi_xi(alpha+1,beta+1) = 0.5;
            Xi_xi_d(alpha+1,beta+1) = (1 - eq(alpha,0))/2;
        else
            Xi_xi(alpha+1,beta+1) = modes(alpha+1,3)*modes(beta+1,3)...
                *((-1)^(alpha + beta) - 1)...
                *(alpha^2 + beta^2)/(pi^2*(alpha^2 - beta^2)^2);
            Xi_d(alpha+1,beta+1) = sqrt(2)*alpha^2*modes(beta+1,3)...
                *((-1)^(alpha + beta) - 1)/(alpha^2 - beta^2);
            Xi_xi_d(alpha+1,beta+1) = sqrt(2)*alpha^2*modes(beta+1,3)...
                *(-1)^(alpha + beta)/(alpha^2 - beta^2);
        end
    end
end

Lambdasf    = diag(modes(:,2));
Wsf         = eye(alpha_mx + 1) + 2*Xi_xi_d;
Asf         = Xi_xi;
Atilsf      = Xi_d;

lmats.Lambdasf  = Lambdasf;
lmats.Wsf       = Wsf;
lmats.Asf       = Asf;
lmats.Atilsf    = Atilsf;

end