0;

% plot pressure alongside modified bessel functions to demonstrate
% asymptotics

set(0,'DefaultAxesFontName','Times')
set(0,'DefaultAxesFontSize',10)
widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
figure('units','centimeters','position',[5 -5 widthCM 0.5*widthCM]);

% geometry
X_i     = 1;
s_o     = 4.5*X_i;
ratio   = 4;

n_s     = 500;

% numerical parameters
pressuredirection = 0;
mach    = 0.1;
omega   = 0.5;
pfwd    = false;
m       = -log(ratio)/(2*s_o);
nu      = sqrt(1 - omega^2/(4*m^2));

sigma_o = -pi*exp(-2*m*s_o)/(2*m*X_i);
sigma_i = -pi/(2*m*X_i);


Ypl_o = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma_o^2/omega^2) + 1))...
    *sqrt(abs(1 - 4*m^2*sigma_o^2/omega^2));
Ypl_i = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma_i^2/omega^2) + 1))...
    *sqrt(abs(1 - 4*m^2*sigma_i^2/omega^2));

% constants - define up to overall constant now then renormalise later
c1 = 1;
c2 = -c1*(f1til(nu,sigma_o) - omega*Ypl_o/(1i*m)*f1(nu,sigma_o))...
    /(f2til(nu,sigma_o) - omega*Ypl_o/(1i*m)*f2(nu,sigma_o));

% unnormalised pressure and velocity
P_i_unnorm = c1*f1(nu,sigma_i) + c2*f2(nu,sigma_i);
U_i_unnorm = 1i*m/omega*(c1*f1til(nu,sigma_i) + c2*f2til(nu,sigma_i));

Y_i = U_i_unnorm/P_i_unnorm;

Spl_i = (2*Ypl_i)\(Y_i + Ypl_i);

% define normalising denominator
if pfwd == true
    denom = Spl_i\P_i_unnorm;
else
    denom = P_i_unnorm;
end

sgrid = 0:s_o/n_s:s_o;
pgrid = zeros(size(sgrid));
Ygrid = zeros(size(sgrid));
Yplgrid = zeros(size(sgrid));

% function grids
besseligrid = zeros(size(sgrid));
besselkgrid = zeros(size(sgrid));
modbesseligrid = zeros(size(sgrid));
modbesselkgrid = zeros(size(sgrid));

for I_s = 1:length(sgrid)
    s = sgrid(I_s);
    sigma   = -pi*exp(-2*m*s)/(2*m*X_i);
    Ypl = 1i*exp(-1i*pi/4*(sign(1 - 4*m^2*sigma^2/omega^2) + 1))...
        *sqrt(abs(1 - 4*m^2*sigma^2/omega^2));

    besseligrid(I_s) = exbesseli(nu,sigma);
    besselkgrid(I_s) = exbesselk(nu,sigma);
    modbesseligrid(I_s) = f1til(nu,sigma);
    modbesselkgrid(I_s) = f2til(nu,sigma);

    P_unnorm = c1*f1(nu,sigma) + c2*f2(nu,sigma);
    U_unnorm = 1i*m/omega*(c1*f1til(nu,sigma) + c2*f2til(nu,sigma));
    Y = U_unnorm/P_unnorm;

    Spl   = (2*Ypl)\(Y + Ypl);
    Smn   = -(2*Ypl)\(Y - Ypl);

    % disp([s,Spl])

    % disp([Y,Ypl])

    if s <= s_o
        if pressuredirection == 1
            PwebsRMS = sqrt(2)*mach*X_i*abs(Spl*P_unnorm/denom);
        elseif pressuredirection == 0
            PwebsRMS = sqrt(2)*mach*X_i*abs(P_unnorm/denom);
        elseif pressuredirection == -1
            PwebsRMS = sqrt(2)*mach*X_i*abs(Smn*P_unnorm/denom);
        end
    else
        if pressuredirection == 1 || pressuredirection == 0
            PwebsRMS = mach*sqrt(pi/omega)*exp(-(m/2)*s_o)*nu/denom;
        elseif pressuredirection == -1
            PwebsRMS = 0;
        end
    end
    pgrid(I_s)  = PwebsRMS;
    Ygrid(I_s)  = Y;
    Yplgrid(I_s)= Ypl;
end


% plot(sgrid,real(pgrid))
% hold on
% plot(sgrid,imag(pgrid))


hold on
plot(sgrid,real(log(real(c1*besseligrid/denom))),'b--',...
    'DisplayName','$$\Re(\log[c_1\mathrm{I}_\nu(\sigma)])$$')
% plot(sgrid,imag(log(real(c1*besseligrid))),'b-.',...
%     'DisplayName','$$\Im(\log[c_1\mathrm{I}_\nu(\sigma)])$$')
plot(sgrid,real(log(real(c2*besselkgrid/denom))),'r--',...
    'DisplayName','$$\Re(\log[c_2\mathrm{K}_\nu(\sigma)])$$')
% plot(sgrid,imag(log(real(c2*besselkgrid))),'r-.',...
%     'DisplayName','$$\Im(\log[c_2\mathrm{K}_\nu(\sigma)])$$')
% plot(sgrid,real(log(real(c1*modbesseligrid))),...
%     'DisplayName','$$\Re(\log[c_1\tilde{\mathrm{I}}_\nu(\sigma)])$$')
% plot(sgrid,imag(log(real(c1*modbesseligrid))),...
%     'DisplayName','$$\Im(\log[c_1\tilde{\mathrm{I}}_\nu(\sigma)])$$')
% plot(sgrid,real(log(real(c2*modbesselkgrid))),...
%     'DisplayName','$$\Re(\log[c_2\tilde{\mathrm{K}}_\nu(\sigma)])$$')
% plot(sgrid,imag(log(real(c2*modbesselkgrid))),...
%     'DisplayName','$$\Im(\log[c_2\tilde{\mathrm{K}}_\nu(\sigma)])$$')
plot(sgrid,real(log(real(pgrid))),'k-','DisplayName',...
    ['$$\log\left(\sqrt{\textstyle\sum_{a = -\infty}^' ...
    '\infty|P^a|^2}/M\right)$$'])

xlabel('$$s$$')
legend

% plot(sgrid,real(besseligrid),'-.')
% hold on
% plot(sgrid,imag(besselkgrid),'--')

exportgraphics(gcf,'modbesselplotting.pdf','ContentType','vector')

% modified bessel function I extended for imaginary nu
function I = exbesseli(nu,sigma)
if imag(nu) == 0
    I = besseli(nu,sigma);
else
    alpha = imag(nu);
    I = 1/pi*integral(@(theta) exp(sigma*cos(theta))...
        .*cosh(alpha*theta),0,pi) - 1i*sinh(alpha*pi)/pi...
        *integral(@(t) exp(-sigma.*cosh(t)-1i*alpha.*t),0,Inf);
end
% modified bessel function K extended for imaginary nu
end
function K = exbesselk(nu,sigma)
if imag(nu) == 0
    K = besselk(nu,sigma);
else
    alpha = imag(nu);
    K = integral(@(t) exp(-sigma.*cosh(t)).*cos(alpha.*t),0,Inf);
end
end
% manually set these as our functions
function sol1 = f1(nu,sigma)
sol1 = exbesseli(nu,sigma);
end
function sol2 = f2(nu,sigma)
sol2 = exbesselk(nu,sigma);
end
% modified solutions (velocity functions)
function modsol1 = f1til(nu,sigma)
if imag(nu) == 0
    modsol1 = sigma*f1(nu+1,sigma) ...
        + (nu+1)*f1(nu,sigma);
else
    alpha = imag(nu);
    modsol1 = 1/pi*integral(@(theta) (1 + sigma.*cos(theta))...
        .*exp(sigma*cos(theta)).*cosh(alpha*theta),0,pi) ...
        - 1i*sinh(alpha*pi)/pi*integral(@(t) (1 -sigma.*cosh(t))...
        .*exp(-sigma.*cosh(t)-1i*alpha.*t),0,625);
end
end
function modsol2 = f2til(nu,sigma)
if imag(nu) == 0
    modsol2 = -sigma*f2(nu+1,sigma) + (nu+1)*f2(nu,sigma);
else
    alpha   = imag(nu);
    modsol2 = integral(@(t) (1 - sigma.*cosh(t))...
        .*exp(-sigma.*cosh(t)).*cos(alpha.*t),0,625);
end
end
