function grids = rthetaframe(geom,numparams,plotparams,Pchoice)

% returns plotting grids and spatially evaluated pressure amplitudes in 
% the r-theta plane

%% DUCT GEOMETRY
R_func      = geom().R;


%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
modes       = numparams.modes;
C_alpha     = modes(:,6)';


%% PLOTTING
s_0                 = plotparams.s_0;
n_theta             = plotparams.n_theta;
n_r                 = plotparams.n_r;


%% PLOTTING GRID
R                   = R_func(s_0);
r                   = 0:R/n_r:R;
theta               = 0:2*pi/n_theta:2*pi;
[rr,thetatheta]     = meshgrid(r,theta);
xx                  = rr.*cos(thetatheta);
yy                  = rr.*sin(thetatheta);


%% INTERPOLANT EVALUATION
S_P         = {s_0, 1:(2*a_mx+1)*(alpha_mx+1)};
P_alpha_a   = reshape(Pchoice(S_P),alpha_mx+1,2*a_mx+1);


%% MODE MULTIPLICATION
disp('summing over modes...')

J_alpha     = zeros(n_r+1,alpha_mx+1);
cos_alpha   = zeros(n_theta+1,alpha_mx+1);
psi_alpha   = zeros(alpha_mx+1,n_r+1,n_theta+1);

for alpha = 0:alpha_mx
    J_alpha(:,alpha+1) ...
        = besselj(modes(alpha+1,3),modes(alpha+1,2)*r/R_func(s_0));
    cos_alpha(:,alpha+1) ...
        = cos(modes(alpha+1,3)*theta - modes(alpha+1,5)*pi/2);
    psi_alpha(alpha+1,:,:) = (1/(sqrt(pi)*R)).*C_alpha(alpha+1)...
        .*J_alpha(:,alpha+1).*(cos_alpha(:,alpha+1))';
end

psi_alpha   = permute(reshape(permute(...
    psi_alpha,[1 3 2]),alpha_mx+1,(n_r+1)*(n_theta+1)),[2 1]);
P_a         = psi_alpha*P_alpha_a;


grids.xx = xx;
grids.yy = yy;
grids.zz = 0;
grids.P_a = P_a;

end
