0;


n_rows      = 2;
n_columns   = 1;



set(0,'DefaultAxesFontName','Times')
set(0,'DefaultAxesFontSize',10)
widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
fig = figure('units','centimeters','position',...
    [5 -5 widthCM 0.4*(n_rows/n_columns)*widthCM]);
tiledlayout(n_rows,n_columns,'TileSpacing','compact','Padding','compact');


filename = ...
    'exphorndecrease2D_alpha050_a001_omega5.0000_linear_s_d04.5000_ptot.mat';

tiles(n_rows*n_columns) ...
    = struct("pp",[],"plotconst",[],"plotparams",[],"maxP",[]);
grid(n_rows*n_columns) = struct("xx",[],"yy",[],"zz",[],"P_a",[]);

plotconst = -1;

n_contours          = 8; %half

maxes = zeros(n_rows*n_columns,1);
nexttile
absol              = false;
contours           = true;
pressuredirection  = 0;
startfrac          = 0.25;
load(filename,'numparams','geomname','geomparams')
geom = eval(strcat(geomname,'(','geomparams',')'));
geom.inner = false;
if pressuredirection == -1
    load(filename,'Pmnint')
    Pchoice = Pmnint;
elseif pressuredirection == 0
    load(filename,'Pint')
    Pchoice = Pint;
elseif pressuredirection == 1
    load(filename,'Pplint')
    Pchoice = Pplint;
else
    disp('bad pressure direction')
end
%point through first cycle at which frames begin, in [0.5,0.5)
omega   = numparams.omega;
mach    = numparams.mach;
a_mx    = numparams.a_mx;
t       = startfrac*2*pi/omega;
%a-vector with all temporal mode information
exp_a_grid = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*t);
exp_a_gridq ...
    = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*(t + 0.5*pi/omega));
if plotconst == 0
    n_r     = 100;
    n_theta = 100;

    plotparams.s_0      = (90/90)*geom.L;
    plotparams.n_r      = n_r;
    plotparams.n_theta  = n_theta;

    grid = rthetaframe(geom,numparams,plotparams,Pchoice);
    P_a = grid.P_a;

    pp = zeros(n_theta+1,n_r+1);
    for I_r = 1:n_r+1
        for I_theta = 1:n_theta+1
            pp(I_theta,I_r) = P_a((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_grid'/mach ...
                + 1i*real(P_a((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_gridq')/mach;
        end
    end
    maxP = max(abs(pp),[],'all');
elseif plotconst == 1
    n_r     = 250;
    n_theta = 150;
    n_s     = 400;

    plotparams.s1       = 0;
    plotparams.s2       = numparams.s_d;
    plotparams.r_0      = 1;
    plotparams.n_r      = n_r;
    plotparams.n_s      = n_s;
    plotparams.n_theta  = n_theta;

    grid = sthetaframe(geom,numparams,plotparams,Pchoice);
    P_a         = grid.P_a;
    P_a_pl01    = P_a.P_a_pl01;
    P_a_pl02    = P_a.P_a_pl02;
    P_a_pl1     = P_a.P_a_pl1;

    pp_pl01 = zeros(n_r+1,n_theta+1);
    pp_pl02 = zeros(n_r+1,n_theta+1);
    pp_pl1  = zeros(n_s+1,n_theta+1);
    for I_r = 1:n_r+1
        for I_theta = 1:n_theta+1
            pp_pl01(I_r,I_theta)...
                = real(P_a_pl01((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_grid')/mach ...
                + 1i*real(P_a_pl01((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_gridq')/mach;
            pp_pl02(I_r,I_theta)...
                = real(P_a_pl02((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_grid')/mach ...
                + 1i*real(P_a_pl02((I_r-1)*(n_theta+1)+I_theta,:)...
                *exp_a_gridq')/mach;
        end
    end
    for I_s = 1:n_s+1
        for I_theta = 1:n_theta+1
            pp_pl1(I_s,I_theta)...
                = real(P_a_pl1((I_s-1)*(n_theta+1)+I_theta,:)...
                *exp_a_grid')/mach ...
                + 1i*real(P_a_pl1((I_s-1)*(n_theta+1)+I_theta,:)...
                *exp_a_gridq')/mach;
        end
    end
    pp = struct("pp_pl1",[],"pp_pl01",[],"pp_pl02",[]);
    pp.pp_pl1   = pp_pl1;
    pp.pp_pl01  = pp_pl01;
    pp.pp_pl02  = pp_pl02;
    maxP = max([max(abs(pp_pl01),[],'all'),...
        max(abs(pp_pl02),[],'all'),max(abs(pp_pl1),[],'all')]);
elseif plotconst == 2
    n_s = 250;
    n_r = 100;

    plotparams.s1   = 0;
    plotparams.s2   = numparams.s_d;
    plotparams.n_s  = n_s;
    plotparams.n_r  = n_r;

    grid = rsframe(geom,numparams,plotparams,Pchoice);
    P_a = grid.P_a;

    pp = zeros(2*n_r+1,n_s+1);
    for I_s = 1:n_s+1
        for I_r = 1:2*n_r+1
            pp(I_r,I_s) = real(P_a((I_s-1)*(2*n_r+1)+I_r,:)...
                *exp_a_grid')/mach ...
                + 1i*real(P_a((I_s-1)*(2*n_r+1) + I_r,:)...
                *exp_a_gridq')/mach;
        end
    end
    maxP = max(abs(pp),[],'all');
elseif plotconst == -1
    n_s = 200;
    n_x = 200;
    plotparams.s1 = 0;
    plotparams.s2 = numparams.s_d;
    plotparams.n_s = n_s;
    plotparams.n_x = n_x;
    grid = xsframe(geom,numparams,plotparams,Pchoice);
    P_a = grid.P_a;

    pp          = zeros(n_x+1,n_s+1);
    for I_s = 1:n_s+1
        for I_x = 1:n_x+1
            pp(I_x,I_s) ...
                = real(P_a((I_s-1)*(n_x+1)+I_x,:)...
                *exp_a_grid')/mach ...
                + 1i*real(P_a((I_s-1)*(n_x+1)+I_x,:)...
                *exp_a_gridq')/mach;
        end
    end
    maxP = max(abs(pp),[],'all');
end


clim manual


outerclim = maxP;
if absol == false
    clim([-outerclim,outerclim]);
else
    clim([0,outerclim])
end

%% DRAW
disp('plotting...')
axis tight
clim manual

if absol == false
    contourlevels = -outerclim:2*outerclim/(2*n_contours+1):outerclim;
    set_custom_colormap(1);
else
    contourlevels = 0:outerclim/(2*n_contours+1):outerclim;
    colormap("turbo");
end

xx = grid.xx;
yy = grid.yy;
zz = grid.zz;

if plotconst == 1
    if absol == false
        plotquantity01  = real(pp.pp_pl01);
        plotquantity02  = real(pp.pp_pl02);
        plotquantity1   = real(pp.pp_pl1);
    else
        plotquantity01  = abs(pp.pp_pl01);
        plotquantity02  = abs(pp.pp_pl02);
        plotquantity1   = abs(pp.pp_pl1);
    end
    xx_pl1  = xx.xx_pl1;
    xx_pl01 = xx.xx_pl01;
    xx_pl02 = xx.xx_pl02;
    yy_pl1  = yy.yy_pl1;
    yy_pl01 = yy.yy_pl01;
    yy_pl02 = yy.yy_pl02;
    zz_pl1  = zz.zz_pl1;
    zz_pl01 = zz.zz_pl01;
    zz_pl02 = zz.zz_pl02;
    plot_pl01 = surf(xx_pl01,yy_pl01,zz_pl01,plotquantity01);
    set(plot_pl01, 'EdgeColor', 'none');
    hold on
    plot_pl02 = surf(xx_pl02,yy_pl02,zz_pl02,plotquantity02);
    set(plot_pl02, 'EdgeColor', 'none');
    plot_pl1 = surf(xx_pl1,yy_pl1,zz_pl1,plotquantity1);
    set(plot_pl1, 'EdgeColor', 'none');
    plot3(xx_pl01(length(xx_pl01(:,1)),:),...
        yy_pl01(length(yy_pl01(:,1)),:),...
        zz_pl01(length(zz_pl01(:,1)),:),'Color','k');
    plot3(xx_pl02(length(xx_pl02(:,1)),:),...
        yy_pl02(length(yy_pl02(:,1)),:),...
        zz_pl02(length(zz_pl02(:,1)),:),'Color','k');
    view(-37.5+180,25)
    xlabel('$$x$$')
    ylabel('$$y$$')
    zlabel('$$z$$')
else
    if absol == false
        plotquantity = real(pp);
    else
        plotquantity = abs(pp);
    end
    if contours == false
        pressureplot = pcolor(xx,yy,plotquantity);
        set(pressureplot, 'EdgeColor', 'none');
    else
        [pressureplot,c] = contourf(xx,yy,plotquantity);
        c.LevelList = contourlevels;
    end

    hold on
    if plotconst == 2
        plot(xx(1,:),yy(1,:),'LineWidth',2,'Color','k');
        plot(xx(length(xx(:,1)),:),yy(length(yy(:,1)),:),...
            'LineWidth',2,'Color','k')
    elseif plotconst == -1
        plot(xx(1,:),yy(1,:),'LineWidth',2,'Color','k');
        plot(xx(n_x+1,:),yy(n_x+1,:),'LineWidth',2,'Color','k')
    end
    xlabel('$$s$$')
end
pos = get(gcf,'Position');
width = pos(3);
height = pos(4);

clim([contourlevels(1),contourlevels(length(contourlevels))]);
% daspect([10/57 16/29 1])
daspect([1 1 1])
% view(90,-90)
C = colorbar;
C.Label.Interpreter = 'latex';
% C.Label.String = pressurelabel;
C.Label.FontSize = 12;
% C.Layout.Tile = 'east';

nexttile

load(filename,'numparams','Ysfint','Ysfplint')
%% ADMITTANCE PLOT
n_s = 1000;
s_d = numparams.s_d;
alpha_mx = numparams.alpha_mx;
a_mx =  numparams.a_mx;
s   = (0:s_d/n_s:s_d);
S_Y = {s, 1:(2*a_mx+1)*(alpha_mx+1)^2};
Ysf     = Ysfint(S_Y);
Ysfpl   = Ysfplint(S_Y);
Ysfnorm = zeros(size(s));
for I_s = 1:n_s+1
    Ysfnorm(I_s) = norm(Ysf(I_s,:) - Ysfpl(I_s,:))...
        /norm(Ysfpl(I_s,:));
end
plot(s,log(Ysfnorm))
xlabel('$$s$$')
ylabel('$$\log\left(\frac{\|\mathsf{Y}^a(s) - \overline{\mathsf{Y}}^{a}(s)\|_2}{\|\overline{\mathsf{Y}}^{a}(s)\|_2}\right)$$')
% width
% height
% set(gcf,'position',[10,10,width,height])

exportgraphics(gcf,'padmtileplaceholderp2.pdf','ContentType','vector')
